<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @since 1.0.0
 *
 * @package Darkbiz WordPress Theme
 */

get_header();
?>
<section id="primary" class="content-area">
	<main id="main" class="site-main container">
		<div class="error-404 not-found">
			<h1><?php echo esc_html__( 'Oops!', 'darkbiz' ) ?></h1>
			<p><?php echo esc_html__( 'This page doesn\'t seem to exist.', 'darkbiz' ) ?></p>
			<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
				viewBox="0 0 1366 840" style="enable-background:new 0 0 1366 768;" xml:space="preserve">
				<style type="text/css">
					.st0{fill:#002E4F;}
					.st1{fill:#00A4E2;}
					.st2{fill:#E1F3F6;}
					.st3{fill:#008DC4;}
					.st4{fill:#00AFE2;}
					.st5{fill:#006091;}
					.st6{fill:#0076AD;}
					.st7{fill:#00D2FD;}
					.st8{fill:#00396A;}
					.st9{fill:none;stroke:#20C6F0;stroke-width:7.6539;stroke-linecap:round;stroke-miterlimit:10;}
					.st10{fill:#0086CF;}
					.st11{fill:#0089E0;}
					.st12{fill:#CDE5E8;}
					.st13{fill:#F6EE9E;}
					.st14{fill:#F8FDFF;}
					.st15{fill:none;stroke:#DDDD67;stroke-width:0.8679;stroke-miterlimit:10;}
					.st16{fill:none;stroke:#DDDD67;stroke-width:0.755;stroke-miterlimit:10;}
					.st17{fill:#009EE7;}
				</style>
				<g>
					<path class="st0" d="M1042.2,700.6c-9.4,12.2-20.5,21.3-18.1,25.5c0,0,5,3.7,18.9,3.7c23.8,0,47.1-1.8,43.3-4.2
						c-5.3-3.3-20.7-4.5-35.4-9.6c-3.6-1.3,8-8.3,4.8-9.4C1049.1,704.1,1044,702,1042.2,700.6z"/>
					<path class="st0" d="M1287.1,725.4c0,0,3.1,4.4,15.1,4.4c20.5,0,42-2.8,38.7-4.9c-4.6-2.9-40.6-10.4-40.6-10.4l-8.1-10l-13.7,7.6
						L1287.1,725.4z"/>
					<g>
						<path class="st1" d="M1222,422.5c-14.7,0-25.9-2.9-26.8-3.2c-7.7-2.1-12.2-10-10.1-17.7c2.1-7.7,10-12.2,17.7-10.1
							c0.5,0.1,33,8.4,51.9-7.8c12.7-10.9,17.5-31.4,14.3-60.9l-1-9.4l29.2-16.5c6.9-3.9,15.7-1.5,19.7,5.4c3.9,6.9,1.5,15.7-5.4,19.7
							l-12.9,7.3c2,34.8-6.4,60.5-25.2,76.5C1257.4,419.2,1237.6,422.5,1222,422.5z"/>
					</g>
					<g>
						<path class="st2" d="M1271.9,342.5c-0.5,21-6.1,36.2-16.7,45.2c-20.8,17.8-56.4,8.7-57,8.6c-8.4-2.3-17.1,2.7-19.4,11.1
							c-2.3,8.4,2.7,17.1,11.1,19.5c1,0.3,13.3,6.4,29.4,5.8c61.4-2.2,98.4-55.1,99.1-86L1271.9,342.5z"/>
					</g>
					<g>
						<path class="st3" d="M1187.5,269c-5.5-2.5-10.9-5.1-16.2-7.9c-50.9,29-115.9,66.1-117.2,67.4c0,0,32.3,51.4,34.4,53.5
							c1.3,1.3,81.4-56.1,139-97.8C1214.2,279.1,1200.5,274.9,1187.5,269z"/>
						<path class="st4" d="M1188.3,267.6c13.3,5.9,27.3,10.1,40.9,15.5c31.7-22.9,56.2-40.8,56.2-40.8l-54.2-15.2
							c0,0-26.1,14.8-58.2,33.1C1178,262.8,1183.1,265.3,1188.3,267.6z"/>
						<polygon class="st5" points="1094.8,200 1126.8,286.5 1189.2,309.4 1110.1,165 		"/>
						<polygon class="st5" points="1192.6,330.6 1146.3,330.6 1187.5,402.5 1250.2,428.9 		"/>
						<path class="st6" d="M1250.2,428.9l-36.8-62.8l-157.5,92.3l-31-52.8l19.4-314.1l70.8-41.5l127.4,217.3l42.9-25.1l35.6,60.8
							l-42.9,25.1L1315,391L1250.2,428.9z M1107.4,185.2l-4,2.3l-10.8,167.7l85.2-50L1107.4,185.2z"/>
						<polygon class="st3" points="972.6,391.3 1025,405.6 1055.9,458.5 1000.6,444.4 		"/>
						<polygon class="st4" points="972.6,391.3 1025,405.6 1044.4,91.6 996.4,80.1 		"/>
						<polygon class="st7" points="996.4,80.1 1044.4,91.6 1115.2,50.1 1066.5,36 		"/>
					</g>
					<path class="st0" d="M1101.7,516.4c0,0,7.7,83,7.7,112.1c0,0-60.4,47.1-75.2,71.7c6.4,4.8,18.9,11.3,27.1,11
						c40.3-38.5,84.6-66,84.6-66s19.1-55.4,25-102.3L1101.7,516.4z"/>
					<path class="st2" d="M1144.8,520.3c13.6,0.1,27.5-2.2,39.2-8.6c-3.9-16.6,4.4-65.5,14.9-91.6c0,0,8.3-18.2,2.5-23.8
						c-21.5-20.7-39.8-19-45.5-19.2c-19.7,16.7-56.5,65.8-55,130.8C1111.1,518.6,1131.7,520.2,1144.8,520.3z"/>
					<path class="st8" d="M1278.1,714.3c7.9-2.2,15.4-5.8,20.3-12.3c-23.3-37.8-108.9-176.9-113.5-187.7c-0.1-0.3-0.2-0.6-0.3-0.9
						c-12.6,6.8-27.6,9.2-42.1,8.6c-12.7-0.5-31-2.3-41.3-11.6c0,0.7,0,1.3,0.1,2c1.8,36.3,122.2,157.3,169.5,203.5
						C1273.2,715.5,1275.8,714.9,1278.1,714.3z"/>
					<g>
						<path class="st1" d="M1029.6,482.7c-3.3,0-6.6-0.5-9.6-1.5c-6.4-2.1-14.8-7.5-18.8-20.9c-2.3-7.6,2.1-15.7,9.7-17.9
							c7.6-2.3,15.7,2.1,17.9,9.7c0.3,0.9,0.5,1.5,0.7,1.8c1.5,0.1,7.3-0.4,21.2-8.6c12.4-7.3,27.1-18.2,41.3-28.7
							c24-17.8,46.7-34.6,65.4-40.5c7.6-2.4,15.7,1.8,18.1,9.4c2.4,7.6-1.8,15.7-9.4,18.1c-14.1,4.5-35.9,20.6-57,36.2
							C1078.4,462.6,1051.2,482.7,1029.6,482.7z"/>
					</g>
					<g>
						<path class="st1" d="M1056.6,471.9c-1.8-8.5-3.6-17.9-9-24.9c-11.6,6.4-16.6,6.9-18,6.8c-0.2-0.3-0.4-0.9-0.7-1.8
							c-2.3-7.6-10.3-12-17.9-9.7c-7.6,2.3-12,10.3-9.7,17.9c4,13.4,12.4,18.8,18.8,20.9c3.1,1,6.3,1.5,9.6,1.5c8.4,0,17.6-3,27.6-8.1
							C1057,473.7,1056.8,472.8,1056.6,471.9z"/>
						<path class="st2" d="M1175.6,385.5c-2.4-7.6-10.5-11.8-18.1-9.4c-18.7,5.9-41.4,22.7-65.4,40.5c-14.2,10.5-28.9,21.4-41.3,28.7
							c-0.6,0.3-1.1,0.6-1.6,0.9c5.4,7.1,14.7,42.3,14.9,43.1c15.3-8,88.7-63.9,104.6-80.7C1174.1,402.8,1178,393.1,1175.6,385.5z"/>
					</g>
					<path class="st9" d="M991.3,444.4"/>
					<g>
						<path class="st1" d="M1009.2,471c-0.9,0-1.7-0.3-2.5-0.8c-11.3-8.1-17.2-23.7-17.5-24.3c-0.8-2.2,0.3-4.6,2.5-5.5
							c2.2-0.8,4.6,0.3,5.5,2.5l0,0c0.1,0.1,5.3,13.8,14.5,20.4c1.9,1.4,2.3,4,1,5.9C1011.8,470.4,1010.5,471,1009.2,471z"/>
					</g>
					<g>
						<path class="st1" d="M1009.2,460.7c-1.3,0-2.6-0.6-3.5-1.8c-5.4-7.7-9.8-25.9-10.2-28c-0.5-2.3,0.9-4.6,3.2-5.1
							c2.3-0.5,4.6,0.9,5.1,3.2c1.2,5.1,5.1,19.6,8.9,25c1.4,1.9,0.9,4.6-1,5.9C1010.9,460.4,1010.1,460.7,1009.2,460.7z"/>
					</g>
					<g>
						<path class="st1" d="M1015.1,458.3c-1.7,0-3.3-1-3.9-2.6c-3.9-9.5-5.4-29.5-5.5-30.4c-0.2-2.3,1.6-4.4,3.9-4.5
							c2.3-0.2,4.4,1.6,4.5,3.9c0.4,5.4,2.1,20.9,4.9,27.8c0.9,2.2-0.2,4.6-2.3,5.5C1016.1,458.2,1015.6,458.3,1015.1,458.3z"/>
					</g>
					<g>
						<path class="st1" d="M1021.4,456.3c-1.9,0-3.6-1.3-4.1-3.2c-2.7-10.4-0.2-20.9-0.1-21.4c0.5-2.3,2.8-3.7,5.1-3.2
							c2.3,0.5,3.7,2.8,3.2,5.1c0,0.2-2,9.1,0.1,17.3c0.6,2.3-0.8,4.6-3.1,5.2C1022.1,456.2,1021.8,456.3,1021.4,456.3z"/>
					</g>
					<g>
						<path class="st1" d="M1192,408.6c-1.9,0-3.9-0.4-5.8-1.3c-6.8-3.2-9.7-11.3-6.5-18.1c3.4-7.1,9.4-14.4,10.1-15.2
							c4.8-5.7,13.4-6.5,19.1-1.6c5.7,4.8,6.5,13.4,1.6,19.1l0,0c-1.7,2-4.9,6.3-6.3,9.3C1202,405.7,1197.1,408.6,1192,408.6z"/>
					</g>
					<g>
						<path class="st10" d="M1194,401.6c1.6,1.8,3.3,3.4,5,5c2.2-1.3,4.1-3.3,5.3-5.8c1.4-2.9,4.6-7.2,6.3-9.3
							c4.8-5.7,4.1-14.3-1.6-19.1c-5.7-4.8-14.3-4.1-19.1,1.6c-0.3,0.3-1.4,1.6-2.8,3.6C1187.2,386.1,1188,395,1194,401.6z"/>
					</g>
					<g>
						<path class="st1" d="M1238.6,386.6c-5.4,13.1-20.4,19.4-33.5,14l0,0c-13.1-5.4-19.4-20.4-13.9-33.5l6.8-16.5
							c5.4-13.1,20.4-19.4,33.5-14l0,0c13.1,5.4,19.4,20.4,13.9,33.5L1238.6,386.6z"/>
					</g>
					<path class="st8" d="M1194,365.1c-2.1,8.8-14.8,6-19.5,1.4c-6.6-6.3-10.5-24.3,4.1-23.3c-10.5-15.8,25-32.9,28.8-14.7
						c2.8-4.7,5.6-8.9,11.8-9.3c4.4-0.3,12.2,3.2,11.6,8.6c6.6-5.2,16.2-4.8,22.7,0.5c2.1,1.7,5.9,5.4,4,8.2c-1,1.5-6.4,2-8.2,2.5
						c3.1-1.4,15.7,1.4,13.2,6.7c-1.2,2.5-7.3,0.3-9.2-0.3c0,0,0,0.6,0,0.6c6.8,3.7,9.5,7.5,8.7,15.9c-0.4,3.9-2.2,11.2-6.8,11.7
						c-2.4,0.3-5.1-1.2-5-3.7c5.6,5.6-2.3,20.7-9.5,13.3c-2.8-2.9-1.4-7.8,1.2-10.3c-4.2-2.4-13.4-15.2-6.9-18.7
						c-3,0.1-17.1-4.7-12.6-8.8c1.2,4.7-4.6,10.8-9.3,8.4c2.9,6.3-5.6,10.9-10.8,11.2c3.2,4-6.6,8.8-9.6,3L1194,365.1z"/>
				</g>
				<g>
					<path class="st11" d="M711.6,313.9c0,0-8.2-31.5,32.6-39l-3.1,37.9L711.6,313.9z"/>
					<g>
						<path class="st12" d="M547.8,393.5c-9,0-17.3-1.8-24.9-5.4c-37.1-17.5-41.3-70.3-41.4-72.5c-0.6-8,5.4-14.8,13.4-15.4
							c7.9-0.6,14.8,5.4,15.4,13.3c0.8,10.6,6.9,40,25,48.5c15,7,38.2-0.1,67.3-20.7c6.5-4.6,15.5-3.1,20.1,3.4
							c4.6,6.5,3.1,15.5-3.4,20.1C592.3,383.9,568.4,393.5,547.8,393.5z"/>
					</g>
					<g>
						<g>
							<path class="st4" d="M624.6,420.6c4-10.5,7.7-21.2,12.1-31.6c-2.9-0.2-5.9-0.6-8.9-1.2c-14-2.7-25.8-8.4-35.6-17.1
								c-9.7-8.7-17.2-19.8-22.5-33.1c-5.3-13.4-8.4-28.5-9.2-45.6c-0.9-17,0.5-35,4.1-53.9c3.7-19.3,9-36.6,16.1-51.9
								c7-15.3,15.5-28.2,25.3-38.7c9.8-10.5,20.9-18,33.1-22.5c12.2-4.5,25.3-5.5,39.3-2.8c11.1,2.1,20.8,6.3,29.3,12.5
								c4.1-8.2,8.5-16.2,12.7-24.2c4.9-9.5,9.5-19.1,13.9-28.8c1.9-4.2,3.5-8.4,5.2-12.7C725.5,61,709.6,55.2,692,51.9
								c-25-4.8-48.5-3.9-70.5,2.7c-22,6.6-41.9,17.6-59.5,33c-17.7,15.4-32.6,34.8-44.9,58.2c-12.3,23.3-21.2,49.4-26.7,78.1
								c-5.5,28.8-6.8,56.2-4,82.5c2.8,26.2,9.6,49.8,20.3,70.6c10.7,20.9,25.1,38.4,43.2,52.6c16.8,13.3,36.6,22.4,59.4,27.5
								C614.7,445,619.9,432.9,624.6,420.6z"/>
							<path class="st5" d="M820,203.7c-2.8-26.2-9.6-49.8-20.3-70.6c-10.7-20.9-25.1-38.4-43.2-52.6c-4.9-3.8-10-7.3-15.3-10.5
								c-1.7,4.2-3.3,8.5-5.2,12.6c-4.5,9.7-9,19.3-13.9,28.8c-4.2,8-8.7,16.1-12.8,24.3c1.5,1.1,2.9,2.3,4.3,3.5
								c9.7,8.7,17.3,19.8,22.8,33.2c5.5,13.4,8.7,28.5,9.6,45.3c0.9,16.8-0.5,34.9-4.2,54.2c-3.6,18.9-9,36.1-16,51.6
								c-7.1,15.5-15.6,28.5-25.7,38.9c-10,10.4-21.2,17.9-33.4,22.4c-9,3.3-18.4,4.7-28.2,4.2c-4.8,11.4-8.8,23.1-13.2,34.7
								c-4.3,11.4-9.2,22.6-14.2,33.7c1.1,0.2,2.2,0.5,3.4,0.7c25,4.8,48.5,3.9,70.5-2.7c22-6.6,41.9-17.6,59.5-33
								c17.7-15.4,32.6-34.8,44.9-58.2c12.3-23.3,21.2-49.4,26.7-78.1C821.5,257.4,822.8,229.9,820,203.7z"/>
						</g>
						<g>
							<path class="st6" d="M658.5,473.1c-25-4.8-46.5-14.3-64.5-28.5c-18.1-14.2-32.5-31.8-43.2-52.6c-10.7-20.9-17.5-44.4-20.3-70.6
								c-2.8-26.2-1.5-53.7,4-82.5c5.5-28.7,14.4-54.8,26.7-78.1c12.3-23.3,27.3-42.7,44.9-58.2c17.7-15.4,37.5-26.5,59.5-33
								c22-6.6,45.5-7.5,70.5-2.7c25,4.8,46.5,14.3,64.5,28.5c18.1,14.2,32.5,31.8,43.2,52.6c10.7,20.9,17.5,44.4,20.3,70.6
								c2.8,26.2,1.5,53.7-4,82.5c-5.5,28.8-14.4,54.8-26.7,78.1c-12.3,23.3-27.3,42.7-44.9,58.2c-17.7,15.4-37.5,26.5-59.5,33
								C706.9,477,683.4,477.9,658.5,473.1z M671.9,402.8c13.6,2.6,26.5,1.6,38.8-2.9c12.2-4.5,23.4-12,33.4-22.4
								c10-10.4,18.6-23.4,25.7-38.9c7.1-15.5,12.4-32.7,16-51.6c3.7-19.3,5.1-37.4,4.2-54.2c-0.9-16.8-4.1-32-9.6-45.3
								c-5.5-13.4-13.1-24.4-22.8-33.2c-9.7-8.7-21.4-14.4-35-17c-14-2.7-27.1-1.7-39.3,2.8c-12.2,4.5-23.3,12-33.1,22.5
								c-9.8,10.5-18.3,23.4-25.3,38.7c-7,15.3-12.4,32.6-16.1,51.9c-3.6,18.9-5,36.9-4.1,53.9c0.9,17,3.9,32.2,9.2,45.6
								c5.3,13.4,12.8,24.4,22.5,33.1C646,394.4,657.9,400.1,671.9,402.8z"/>
						</g>
					</g>
					<g>
						<path class="st8" d="M913,261.3l1.1,53c0,0-15.1,13.6-28.7,0l5-59.7L913,261.3z"/>
						<path class="st0" d="M850.5,684.4c-0.9-0.7-6.8-3.4-7.6-4.1c-3.2,4.8-5.4,7.4-9.2,11.3c9.4,8.2,6.9,18.1,6.9,18.1s-6.6,5.7-9.2,7
							c-8.3,4.1-23.5,9.7-23.5,9.7l38.3,3l28.4-29.1C864.7,694.6,856.9,689.5,850.5,684.4z"/>
						<path class="st0" d="M700.3,686.4c-6.1-1.1-13.8,3.6-18.8,0c-1.2,10.7-0.9,16.5-0.9,16.5l-56.7,23.4h72.4
							c0.7-7.7-0.7-15.1,0.3-22.3C697.2,700.4,699.7,690,700.3,686.4z"/>
						<path class="st12" d="M766.4,429.1l-64.1,121.8c0,0,26,22,51.5,29.3l48-143.5L766.4,429.1z"/>
						<path class="st0" d="M836.5,694.6c3.8-3.9,7-8.6,10.2-13.4c-16.6-14.2-24.7-28.8-47.2-54c-9.3-10.4,15.4-70.1,21.4-80.1
							c10.8-18,12.4-31,20.9-61.8l-62.6,23.4c-14.9,53.4-32.3,106.7-14.9,132.2c18.4,26.9,51,48.6,66.8,59.4
							C831.6,700.6,836,694.2,836.5,694.6z"/>
						<g>
							<path class="st1" d="M731.1,307.6c-0.9,0-1.7-0.3-2.5-0.8c-1.9-1.4-2.3-4-1-5.9c5-7,6.1-12.8,6.2-12.9c0.4-2.3,2.6-3.8,4.9-3.4
								c2.3,0.4,3.8,2.6,3.4,4.9c-0.1,0.3-1.4,7.6-7.6,16.3C733.8,307,732.5,307.6,731.1,307.6z"/>
						</g>
						<path class="st13" d="M837.3,498.1c18.6-51.1,34.5-131.4,40.5-163.4c-3.3-1.4-6.6-2.4-9.2-3.1c-5.5-1.5-12.1-3.3-17.8-1.6
							c-2.9,0.9-5.4,2.4-7.9,4c-2.3,7-3.3,12.8-3.3,12.8s-40,76.5-66.1,128.7C795.6,480.4,817.2,487.6,837.3,498.1z"/>
						<path class="st8" d="M772.7,477C772.7,477,772.7,477,772.7,477c-2.3,4.6-4.5,9-6.6,13.2c0,0,0,0,0,0c-5.1,9.1-10.7,17.5-16,25.6
							c-51.5,77.6-70.9,139.5-74.4,168.8c4.9,3.8,23.5,6,29.7,7.1c9.5-48.5,34.2-79.5,78.5-116.1c14.8-12.3,25.9-27.8,35.6-40.7
							c5.8-7.7,11.6-20.1,17.1-35C816.6,489.2,794.9,481.9,772.7,477z"/>
						<g>
							<path class="st1" d="M722.7,498.3c-6,0-11.6-3.7-13.6-9.7c-2.6-7.5,1.4-15.8,8.9-18.4c17.5-6.1,44.4-30,62.5-55.7
								c36.7-52.1,62.5-81,63.6-82.2c5.3-5.9,14.4-6.4,20.4-1.1c5.9,5.3,6.4,14.4,1.1,20.4l0,0c-0.3,0.3-25.8,29-61.5,79.5
								c-17.9,25.3-49.5,56.9-76.6,66.3C725.9,498.1,724.3,498.3,722.7,498.3z"/>
						</g>
						<g>
							<path class="st1" d="M867.6,339.5c-0.3,0-0.7,0-1,0c-7.5-0.6-13.1-7.1-12.6-14.5c0.6-7.8,3.6-16.8,3.9-17.8
								c2.4-7.1,10.2-10.9,17.3-8.4c7.1,2.4,10.8,10.2,8.4,17.3c-0.9,2.5-2.3,7.7-2.5,10.9C880.6,334,874.7,339.4,867.6,339.5z"/>
						</g>
						<g>
							<path class="st10" d="M871.6,325.1c2.4,2.8,5,5.2,7.8,7.5c1-1.7,1.6-3.6,1.8-5.7c0.2-3.2,1.7-8.4,2.5-10.9
								c2.4-7.1-1.3-14.8-8.4-17.3c-5.9-2-12.2,0.2-15.6,5.1C861,311.5,867.2,320.1,871.6,325.1z"/>
						</g>
						<g>
							<path class="st1" d="M906.6,295.7c-0.3,14.2-12.1,25.4-26.2,25.1l0,0c-14.2-0.3-25.4-12.1-25.1-26.2l0.4-17.8
								c0.3-14.2,12.1-25.4,26.2-25.1l0,0c14.2,0.3,25.4,12.1,25.1,26.2L906.6,295.7z"/>
						</g>
						<g>
							<path class="st1" d="M702.3,494.3c-5.9,0-12.7-1.6-20.3-4.8c-2.2-0.9-3.2-3.4-2.3-5.6c0.9-2.2,3.4-3.2,5.6-2.3
								c11.2,4.7,20.1,5.4,25.7,1.9c2-1.2,4.6-0.6,5.8,1.4c1.2,2,0.6,4.6-1.4,5.8C711.7,493.2,707.3,494.3,702.3,494.3z"/>
						</g>
						<g>
							<path class="st1" d="M707.4,500.5c-6.8,0-12.2-1.3-18.3-2.8l-1.9-0.5c-2.3-0.5-3.7-2.8-3.1-5.1c0.5-2.3,2.8-3.7,5.1-3.1l1.9,0.5
								c10.3,2.5,17.1,4.1,32.1,0.3c2.3-0.6,4.6,0.8,5.2,3c0.6,2.3-0.8,4.6-3,5.2C718.1,499.8,712.4,500.5,707.4,500.5z"/>
						</g>
						<g>
							<path class="st1" d="M702.1,486c-13.3,0-22.4-8.2-22.9-8.6c-1.7-1.6-1.8-4.3-0.3-6c1.6-1.7,4.3-1.8,6-0.3
								c0.4,0.4,10.2,9,23.3,5.6c2.3-0.6,4.6,0.8,5.2,3c0.6,2.3-0.8,4.6-3.1,5.2C707.4,485.7,704.7,486,702.1,486z"/>
						</g>
						<g>
							<path class="st1" d="M710.9,481.4c-0.2,0-0.3,0-0.5,0c-14.5-1.7-20.3-12.1-20.6-12.5c-1.1-2.1-0.4-4.6,1.7-5.8
								c2-1.1,4.6-0.4,5.7,1.6c0.2,0.3,4.2,7.1,14.1,8.2c2.3,0.3,4,2.4,3.7,4.7C714.9,479.8,713.1,481.4,710.9,481.4z"/>
						</g>
						<g>
							<path class="st1" d="M761.7,313.7c-0.2,0-0.5,0-0.7-0.1c-7-1.2-26.2-4.2-30.7-4.2c-2.3,0-4.2-1.9-4.2-4.2c0-2.3,1.9-4.2,4.2-4.2
								c6,0,29.4,3.9,32.1,4.3c2.3,0.4,3.9,2.6,3.5,4.9C765.5,312.2,763.7,313.7,761.7,313.7z"/>
						</g>
						<g>
							<path class="st1" d="M758.9,322.6c-0.4,0-0.7,0-1.1-0.2c-0.2-0.1-20.4-5.5-29.8-6.1c-2.3-0.1-4.1-2.1-4-4.5
								c0.1-2.3,2.2-4.2,4.5-4c10.3,0.6,30.7,6.1,31.5,6.4c2.3,0.6,3.6,2.9,3,5.2C762.5,321.4,760.8,322.6,758.9,322.6z"/>
						</g>
						<g>
							<path class="st1" d="M756.9,332c-0.4,0-0.9-0.1-1.3-0.2c-19.1-6.2-23.8-6.5-26.3-6.8c-1.1-0.1-2.1-0.2-3.5-0.5
								c-2.3-0.6-3.6-2.9-3-5.2c0.6-2.3,2.9-3.6,5.2-3c0.7,0.2,1.2,0.2,2,0.3c3.1,0.2,8.2,0.7,28.3,7.1c2.2,0.7,3.5,3.1,2.7,5.3
								C760.4,330.8,758.7,332,756.9,332z"/>
						</g>
						<g>
							<path class="st1" d="M748.5,338.8c-0.1,0-0.2,0-0.3,0c-19.1-1.4-19.9-11.8-20-12.9l8.5-0.2c0,0,0-0.1,0-0.3c0,0,0.9,4.1,12.1,5
								c2.3,0.2,4.1,2.2,3.9,4.5C752.6,337,750.7,338.8,748.5,338.8z"/>
						</g>
						<path class="st1" d="M732.5,333.7c0,0-3.7-1.7-9.4-1.7c-4.8,0-11.4-8.2-11.4-16.7c0,0-2.4-25.1,24.1-13.7L732.5,333.7z"/>
						<path class="st12" d="M815.8,408.1l-37.1,182.6c0,0,57.4,13.8,92.6-6.5l8.9-253.7C880.3,330.6,840.8,316.8,815.8,408.1z"/>
						<path class="st2" d="M824.4,508.6l35.5-1.9c0,0,0.9,54.3-20.4,52.2C839.5,558.9,810.5,565.2,824.4,508.6z"/>
						<path class="st2" d="M869,326.3c-3.9-3.5-8.9-5.4-14.2-5.4c-6,0-11.8,2.6-15.8,7c-1.1,1.2-27,30.2-64.1,82.8
							c-2.4,3.4-5.1,7-7.9,10.4l-3.8,4.6l4.1,4.3c4.4,4.6,9,9.1,13.4,13.5c2.4,2.4,4.8,4.7,7.2,7.1l5.2,5.3l4.8-5.7
							c4.3-5.1,8.2-10.2,11.7-15.1c35.4-50.3,60.8-78.6,61-78.9C878.4,347.5,877.7,334.1,869,326.3z"/>
						
							<rect x="772.3" y="409.1" transform="matrix(0.6683 -0.7439 0.7439 0.6683 -63.2487 726.4694)" class="st14" width="21.4" height="50.2"/>
						<path class="st8" d="M829.5,305.9l32.6,12.8c0,0,13.9-67.5,3.7-77.6C865.9,241.1,829.5,237.6,829.5,305.9z"/>
						<path class="st8" d="M867.7,252.8c1.2,1.7,26.5,18.6,46.3,13.9c0,0-3.4-29.8-49.8-25.5L867.7,252.8z"/>
						<path class="st15" d="M887.3,284.7c0,7.8-6.4,14.2-14.2,14.2s-14.2-6.4-14.2-14.2c0-7.8,6.4-14.2,14.2-14.2
							S887.3,276.8,887.3,284.7z"/>
						<path class="st16" d="M919.3,287.4c0,6.8-5.5,12.3-12.3,12.3c-6.8,0-12.3-5.5-12.3-12.3c0-6.8,5.5-12.3,12.3-12.3
							C913.8,275.1,919.3,280.6,919.3,287.4z"/>
						<path class="st15" d="M887.3,284.7c0,0,4.7-1.8,7.5,1"/>
					</g>
					<g>
						<g>
							<path class="st10" d="M474.5,309.5c-0.3,0-0.7,0-1,0c-7.5-0.5-13.1-7.1-12.6-14.5c0.6-7.8,3.6-16.8,3.9-17.8
								c2.4-7.1,10.2-10.9,17.3-8.4c7.1,2.4,10.8,10.2,8.4,17.3c-0.9,2.5-2.3,7.7-2.5,10.9C487.5,304.1,481.5,309.5,474.5,309.5z"/>
						</g>
						<g>
							<path class="st0" d="M466.4,686.4c22.5,10.4,40.9,10.2,42.4,10.4c14.7-26.1,58.8-96.8,18.7-154.8l-56.8-30.6
								C470.7,511.4,527.5,570.7,466.4,686.4z"/>
							<path class="st0" d="M495.9,709.5c0,0,5.3-10.7,9.4-17.8c-3.1-0.4-16.8-0.9-22.5-3.1c-5.3,10.8-16.9,26.7-25,37.6h76.4
								L495.9,709.5z"/>
							<path class="st8" d="M590.3,545.4c-9.5-18.4-78.5-74-84.7-105.9c-0.6-2.8-1-5.7-1.4-8.7c-11.1,5.9-25.5,7.5-36.9,8
								c-12.9,0.7-20.7,1.5-33.2-4.6c1.1,19.8-2.2,38.9,9.4,59c22.9,39.8,99.1,73.8,107.5,87c16.7,25.9,22.5,82.2,28.2,116.6
								c9,0,30.2-0.4,39-3.5C615.3,675.6,620.1,603.2,590.3,545.4z"/>
							<path class="st0" d="M614.1,706.4c0,0-2.5-10-3.2-14.7c-8.7,3.1-13.8,0-22.8,0c1.4,8.5,0.4,24.4,1.1,33.8h72.4L614.1,706.4z"/>
							<path class="st12" d="M467.8,449.3c11-0.5,34.2-3.6,43.5-12.9c-1.9-15.1-8.7-39.5-6.3-59.1c8.1-66.5-24.4-86.4-24.4-86.4
								s-14.9-10.4-27,2c-18.3,18.8-36.1,72-34.3,150.6C431.9,450,454.6,449.9,467.8,449.3z"/>
						</g>
						<g>
							<path class="st1" d="M634.3,470.3c-1.1,0-2.2-0.1-3.3-0.4c-52.3-12.1-96.6-43.5-128.1-90.6c-23.6-35.3-31.8-67-32.1-68.4
								c-1.9-7.7,2.7-15.6,10.5-17.5c7.7-1.9,15.6,2.7,17.5,10.4c0.2,0.6,7.7,29.1,28.7,60.2c27.7,41,64.7,67.2,110.1,77.7
								c7.8,1.8,12.6,9.6,10.8,17.3C646.8,465.8,640.8,470.3,634.3,470.3z"/>
						</g>
						<path class="st2" d="M602.5,426.9c-28.8-13.6-53.3-35.3-72.9-64.3c-20.7-30.7-28.2-59.1-28.3-59.4c-1.9-7.5-8.7-12.8-16.4-12.8
							c-1.4,0-2.8,0.2-4.2,0.5c-4.4,1.1-8.1,3.9-10.4,7.8c-2.3,3.9-3,8.5-1.9,12.9l0.1,0.3c2.2,9.7,11.2,43.9,32.4,75.6
							c25.4,38,59.9,66.5,99.6,82.3c0.3,0.1,0.6,0.2,0.9,0.2c0.5,0,1-0.1,1.4-0.4c0.7-0.5,1.1-1.3,1.1-2.1v-38.2
							C603.9,428.2,603.4,427.3,602.5,426.9z"/>
						<g>
							<path class="st1" d="M645,471.3c-4.6,0-9.5-0.5-14.7-1.6c-2.3-0.5-3.8-2.7-3.3-5c0.5-2.3,2.7-3.8,5-3.3
								c12.6,2.5,23.2,1.6,31.3-2.7c2.1-1.1,4.6-0.3,5.7,1.8c1.1,2.1,0.3,4.6-1.8,5.7C660.8,469.6,653.4,471.3,645,471.3z"/>
						</g>
						<g>
							<path class="st1" d="M645.6,461.8c-2,0-4.1-0.1-6.2-0.4c-2.3-0.3-3.9-2.5-3.6-4.8c0.3-2.3,2.5-3.9,4.8-3.6
								c13.6,2,26.1-5.1,26.3-5.1c2-1.2,4.6-0.5,5.8,1.6c1.2,2,0.5,4.6-1.6,5.8C670.5,455.5,659.4,461.8,645.6,461.8z"/>
						</g>
						<g>
							<path class="st1" d="M641.8,453.5c-0.7,0-1.3,0-2-0.1c-2.3-0.1-4.1-2.2-4-4.5c0.1-2.3,2.2-4.1,4.5-4c10,0.6,15.3-5.5,15.4-5.5
								c1.5-1.8,4.2-2.1,6-0.6c1.8,1.5,2.1,4.1,0.6,6C662,445.1,655,453.5,641.8,453.5z"/>
						</g>
						<g>
							<path class="st1" d="M627.1,446.3c-2.3,0-4.2-1.9-4.2-4.2c0-2.3,1.9-4.2,4.2-4.2c0.4,0,8.8-0.2,13.6-7.1c1.3-1.9,4-2.4,5.9-1.1
								c1.9,1.3,2.4,4,1.1,5.9C640.3,446.2,627.7,446.3,627.1,446.3z"/>
						</g>
						<g>
							<path class="st1" d="M613.3,350.5c-1.3,0-2.6-0.6-3.5-1.8c-6.3-8.7-7.6-16-7.6-16.3c-0.4-2.3,1.2-4.5,3.5-4.9
								c2.3-0.4,4.5,1.1,4.9,3.5c0,0,1.1,5.8,6.2,12.8c1.4,1.9,0.9,4.6-1,5.9C615,350.3,614.1,350.5,613.3,350.5z"/>
						</g>
						<g>
							<path class="st1" d="M614.1,352.4c-0.3,0-0.5,0-0.8-0.1c-9.3-1.8-27.7-1.8-27.9-1.8c-2.3,0-4.2-1.9-4.2-4.2s1.9-4.2,4.2-4.2
								c0.8,0,19.4,0,29.5,2c2.3,0.4,3.8,2.7,3.4,5C617.9,351,616.1,352.4,614.1,352.4z"/>
						</g>
						<g>
							<path class="st1" d="M583.1,361.2c-2.1,0-3.9-1.6-4.2-3.7c-0.3-2.3,1.4-4.4,3.7-4.7c2.7-0.3,26.5-3.2,34.2-1.9
								c2.3,0.4,3.8,2.6,3.4,4.9c-0.4,2.3-2.6,3.9-4.9,3.4c-4.9-0.9-22,0.7-31.7,1.9C583.5,361.2,583.3,361.2,583.1,361.2z"/>
						</g>
						<g>
							<path class="st1" d="M588.6,370.8c-2,0-3.8-1.4-4.2-3.4c-0.4-2.3,1.1-4.5,3.4-5c10.3-2,13-2.9,18-4.5c2.3-0.8,5.2-1.7,9.6-2.9
								c2.2-0.6,4.6,0.6,5.3,2.9c0.7,2.3-0.6,4.6-2.9,5.3c-4.2,1.2-6.9,2.1-9.3,2.9c-5.1,1.6-8.2,2.6-19,4.7
								C589.2,370.8,588.9,370.8,588.6,370.8z"/>
						</g>
						<g>
							<path class="st1" d="M597.8,377.6c-2,0-3.8-1.5-4.2-3.5c-0.4-2.3,1.2-4.5,3.5-4.9c13.7-2.4,16.5-7.5,16.5-7.5
								c0.7-2.2,3.1-3.4,5.4-2.7c2.2,0.7,3.4,3.1,2.7,5.4c-0.5,1.6-4.2,10-23.1,13.2C598.3,377.6,598,377.6,597.8,377.6z"/>
						</g>
						<path class="st1" d="M614.1,372.5l-3.2-34.6c0,0,15.2,1.1,15.1,17C626,360.2,624.5,366.1,614.1,372.5z"/>
						<g>
							<path class="st1" d="M518.6,259.8c3.8,14.5-4.8,29.3-19.3,33.2l0,0c-14.5,3.8-29.3-4.8-33.2-19.3l-4.8-18.2
								c-3.8-14.5,4.8-29.3,19.3-33.2l0,0c14.5-3.8,29.3,4.8,33.2,19.3L518.6,259.8z"/>
						</g>
						<g>
							<path class="st8" d="M516.1,250.2c-2.1,5.7-5,11.4-9.5,15.3c-10.9,9.4-27.7,12-40.9,6.3l0.5,1.9c3.8,14.5,18.7,23.1,33.2,19.3
								c14.5-3.8,23.1-18.7,19.3-33.2L516.1,250.2z"/>
						</g>
						<path class="st8" d="M466.1,272.7c-10.2-6.5-21.2-31.4-5.1-36.8c10-3.4,5.9,27.3,5.9,36L466.1,272.7z"/>
						<path class="st8" d="M457.9,237.9c-12.3-8.9,2.9-34.2,33.4-34.2c18.8,0,18.7,14.4,5.7,22.2c-10.8,6.5-27.5,2.7-35.6,13.7
							L457.9,237.9z"/>
						<path class="st8" d="M516.1,255.7c-4.3-6.5-12.8-19.8-16.1-27.2c-2.1-4.7-5-12.8,4.5-7.1c7.9,4.8,12.3,21.7,11.5,30.3L516.1,255.7
							z"/>
					</g>
				</g>
				<g>
					<g>
						<path class="st5" d="M301.1,316.1c-4.7,4.3-9.8,8.4-14.1,13.2l-61.3,128l45.6-58.9l48.4-100.1
							C313.6,304.2,307.4,310.2,301.1,316.1z"/>
						<path class="st5" d="M264.8,295.1c4.4-6.1,8.7-13.2,13.8-19.5l-107.2-52.3L69.6,233.4l178.2,82.2
							C253.7,308.9,259.6,302.2,264.8,295.1z"/>
						<path class="st4" d="M280.1,276.3c-5.7,7.1-10.3,15.5-15.8,22.2c-4.9,6-9.8,11.9-14.9,17.8l81,37.4l29.4-38.4L280.1,276.3z"/>
						<path class="st6" d="M158.1,424.8l31.4-65.7L24.8,280.3l26.4-55.2L322.4,65.4l74,35.4L287.7,328l44.8,21.5L302,413l-44.8-21.4
							l-31.4,65.7L158.1,424.8z M280,170l-4.2-2l-145,84.9l89.1,42.7L280,170z"/>
						<polygon class="st5" points="332.5,349.5 359.9,315.3 338.4,362.9 301,415.1 		"/>
						<path class="st5" d="M322,296.4L428.9,62l-32.5,38.9L287.7,328C290.7,325.1,320.2,298.1,322,296.4z"/>
						<polygon class="st17" points="51.3,225.1 99.6,183.1 364.5,31 322.4,65.4 		"/>
						<polygon class="st7" points="322.4,65.4 396.4,100.9 428.9,62 364.5,31 		"/>
					</g>
					<path class="st1" d="M231.6,236.6c-9.1-6.5-15.4-3.6-19.7-3c-4.8,0.7-8.3-1.9-8.3-1.9c-2-1.3-4.6-0.7-5.9,1.3
						c-1.3,2-0.7,4.6,1.3,5.9c0.2,0.1,3.9,2.5,10.4,4.2c-7.1,6.4-14.3,14.2-14.7,14.6c-1.6,1.7-1.5,4.4,0.2,6c0.8,0.8,1.8,1.1,2.9,1.1
						c1.1,0,2.3-0.5,3.1-1.4c0.1-0.1,5.1-5.5,10.7-10.9c-5.2,6.5-10.1,13.3-11,14.5c-1.4,1.9-0.9,4.6,1,5.9c0.7,0.5,1.6,0.8,2.5,0.8
						c1.3,0,2.6-0.6,3.4-1.8c2.8-3.9,6.7-9.1,10.4-13.8c-1.4,2.8-3.2,5.9-6.7,11.6c-1.2,2-0.6,4.6,1.4,5.8c0.7,0.4,1.5,0.6,2.2,0.6
						c1.4,0,2.8-0.7,3.6-2c1.5-2.3,2.6-4.3,3.6-6c-0.7,1.8-0.1,4,1.6,5.1c0.7,0.5,1.5,0.7,2.3,0.7c1.4,0,2.7-0.7,3.6-1.9
						c4-6.1,5.9-11.1,6.7-15l0.2,0.1C238.8,245.4,235.9,239.7,231.6,236.6z M223.1,266.5c1.4-2.5,2.4-4.3,3.3-6.2
						C225.6,262.1,224.6,264.2,223.1,266.5z"/>
					<path class="st8" d="M101.7,284.8c-13.4-0.8-32.9,25.5-13,32.7c-18.1-0.4-22.5,25.1-5.9,32.1c-29-5.6-25.6,31.9-11.9,45.5
						c-9.3-1.5-18.7,7.4-17.3,17.1c1.4,9.7,5.3,23.2,29.4,30.5c24.1,7.2,38.8-6.3,50.8-19.1c7.7,15.7,45.6-5.5,41.4-24.3
						c14.3,5.1,27.1-11.2,27.4-24.1c0.3-12.7-8.6-22.3-17-30.6c5.9-5.4,7.1-15.5,5.5-23.2c-2.6-12.8-18.6-14.1-18.6-24.3
						c0-3.6,0.7-14.6-2.4-19.5c-4.8-7.7-13.3-15.4-23.9-11.6C101.7,244.8,101.7,284.8,101.7,284.8z"/>
					<path class="st0" d="M127.6,696.7c-12.2-2.1-14.2-1.5-26.3-4.5l-28,34.2h108.6l-63.1-17L127.6,696.7z"/>
					<path class="st0" d="M329.9,706.6l-6.4-8.4c-5.8,3.7-11.8,7-18.4,9.2l17.2,19.1h63.7L329.9,706.6z"/>
					<path class="st0" d="M89.8,696.9c12.2,3,24.3,6.1,36.7,8.2l89.7-110.4l-15.3-43.8l-62.8-72.4L156.2,581L89.8,696.9z"/>
					<path class="st8" d="M211.8,448c-24.6-6.5-58,1.7-81.9,10.8c0,0,14.7,58.5,24.3,75.9c28.1,50.8,149.5,177.5,149.5,177.5
						c6.7-2.3,19.5-11.7,25.4-15.5L211.8,448z"/>
					<path class="st12" d="M126.6,481.6c23.8-8.9,71.4-24,95.9-17.9c0,0-32.4-76.1-47.1-92.9c-9.9-11.3-64.1-43.2-64.1-1.5
						C111.3,426.5,126.6,481.6,126.6,481.6z"/>
					<g>
						<path class="st1" d="M147.7,365.8c-0.3,0.1-0.6,0.2-1,0.3c-7.2,2-14.7-2.3-16.6-9.6c-2-7.6-2.1-17-2.1-18.1
							c0-7.5,6-13.6,13.5-13.6c7.5,0,13.6,6,13.6,13.5c0,2.6,0.4,8,1.2,11.1C158.2,356.4,154.4,363.5,147.7,365.8z"/>
					</g>
					<g>
						<path class="st10" d="M156.8,352.4c0-1-0.2-2-0.4-2.9c-0.8-3.1-1.2-8.5-1.2-11.1c0-7.5-6.1-13.5-13.6-13.5
							c-7.5,0-13.6,6.1-13.5,13.6c0,0.2,0,0.6,0,1.1C134.7,347.2,145.7,350.7,156.8,352.4z"/>
					</g>
					<g>
						<path class="st1" d="M170.1,311.7c4.4,13.5-3,28-16.5,32.4l0,0c-13.5,4.4-28-3-32.4-16.5l-5.5-17c-4.4-13.5,3-28,16.5-32.3l0,0
							c13.5-4.4,28,3,32.4,16.5L170.1,311.7z"/>
					</g>
					<path class="st1" d="M321.3,298.1c-0.5-0.5-1.2-0.7-1.8-0.9c0.6-0.7,1.3-1.4,2.1-2.2c1.6-1.7,1.5-4.4-0.2-6
						c-0.2-0.2-0.4-0.4-0.7-0.5c1.2-1.7,1-4-0.6-5.5c-1.2-1.1-2.9-1.4-4.3-0.9c1.9-2,3.1-3.3,3.3-3.5c1.5-1.8,1.4-4.4-0.4-6
						c-1.8-1.5-4.4-1.4-6,0.4c-0.1,0.1-9.3,10.5-18.8,15.9c-4.1-6.2-9.6-8.4-10-8.5c-2.2-0.8-4.6,0.3-5.4,2.4c-0.8,2.2,0.2,4.6,2.4,5.5
						c0.2,0.1,3.4,1.5,6,5.3c-0.3,1-0.8,2.3-1,3.9c-62.4,84.5-145.3,54.5-149,53.1c-7.4-2.8-15.7,0.8-18.6,8.3
						c-2.9,7.4,0.8,15.8,8.2,18.7c1,0.4,21.3,8.1,50.2,8.1c5.8,0,12-0.3,18.4-1.1c31.2-3.6,77.3-21.6,114.1-69.1
						c0.6-0.3,1.5-0.9,2.6-1.7c0.8-0.5,1.5-1,2.3-1.7l-0.1-0.1c2.2-1.8,4.9-4.4,7.9-8.1C323.3,302.2,323.1,299.6,321.3,298.1z"/>
					<path class="st2" d="M206.3,350.9l-3.5,0.8c-8.6,1.8-17.5,2.8-26.4,2.8c-21.9,0-37.1-5.5-38.7-6.1c-2-0.8-4-1.1-6.1-1.1
						c-7.1,0-13.3,4.2-15.8,10.8c-1.6,4.2-1.9,9,0.3,13c8.3,14.7,31,20.6,60.5,20.6c6.3,0,12.6-0.4,18.7-1.1c3.8-0.4,7.7-1.1,11.7-1.9
						l2.5-0.6c0,0-3.5-10.7-4.3-21.6C204.9,362.2,206.3,350.9,206.3,350.9z"/>
					<path class="st8" d="M115.2,324.2c8.9-5.7,12-16.3,11-26.9c7.8,5.3,14,2,18.9-7c14.8,20.7,37.4-10.1,6.6-21.3
						c-24.6-8.9-48.7,15.4-42.4,39.9L115.2,324.2z"/>
				</g>
			</svg>
			<div>
				<p><?php esc_html_e( 'It looks like the link pointing here was faulty. Maybe try searching?', 'darkbiz' ) ?></p>
				<?php get_search_form(); ?>
				<a href="<?php echo esc_url( home_url( '/' ) ) ?>" 
					class="<?php echo esc_attr( Darkbiz_Helper::with_prefix( 'btn-primary' ) ); ?>">
					<?php echo esc_html__( 'Goto Homepage', 'darkbiz' ) ?>
					<i class="fa fa-long-arrow-right" aria-hidden="true"></i>
				</a>
			</div>
		</div><!-- .error-404 -->
	</main><!-- #main -->
</section><!-- #primary -->
<?php
get_footer();