<?php
/**
 * Template if no post are found
 *
 * @since 1.0.0
 *
 * @package Darkbiz WordPress Theme
 */
?>
<section class="no-results not-found">
	<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
		viewBox="0 0 750 470" style="enable-background:new 0 0 750 500;" xml:space="preserve">
	<style type="text/css">
		.st0{fill:#FFFFFF;}
		.st1{opacity:0.81;fill:#ECF1F7;}
		.st2{opacity:0.47;fill:#ECF1F7;}
		.st3{fill:#ECF1F7;}
		.st4{opacity:0.58;fill:#3E479B;}
		.st5{opacity:0.58;fill:#EF929C;}
		.st6{opacity:0.47;fill:#FFFFFF;}
		.st7{fill:#3E479B;}
		.st8{fill:#4C65BA;}
		.st9{opacity:0.9;fill:#FFFFFF;}
		.st10{opacity:0.15;fill:#FFFFFF;}
		.st11{opacity:0.5;fill:#FFFFFF;}
		.st12{opacity:0.7;fill:#FFFFFF;}
		.st13{opacity:0.1;fill:#FFFFFF;}
		.st14{opacity:0.3;fill:#FFFFFF;}
		.st15{opacity:0.47;fill:#599AF2;}
		.st16{opacity:0.21;fill:#FFFFFF;}
		.st17{fill:#599AF2;}
		.st18{opacity:0.1;}
		.st19{fill:#EF929C;}
	</style>
	<g id="BACKGROUND">
		<rect class="st0" width="750" height="500"/>
		<g>
			<g>
				<path class="st1" d="M51.6,240.4c-11.2-8.7-13.2-24.9-4.5-36c8.7-11.2,30.9-21,42.1-12.2c11.2,8.7-1.9,26.7-4.1,40.7
					C82,252.4,62.8,249.2,51.6,240.4z"/>
				<path class="st2" d="M684.3,311.2c9.8,3,15.2,13.4,12.2,23.1c-3,9.8-15.5,22-25.2,19c-9.8-3-5.6-18.5-7.6-28.5
					C660.8,310.9,674.5,308.2,684.3,311.2z"/>
				<path class="st2" d="M666.8,91.8c-4.3,13.8-18.9,21.6-32.7,17.3c-13.8-4.3-31.2-21.9-26.9-35.7c4.3-13.8,26.1-7.9,40.3-10.8
					C667.2,58.4,671,78,666.8,91.8z"/>
			</g>
			<g>
				<path class="st3" d="M621.9,388.6c5.4-27.4-3.1-50.7-5.1-77.6c-1.9-25.4,6.8-46.8,11.7-71c4.3-21.6,3-46-2.4-67.1
					c-7.3-28.9-24.1-55.6-48.5-71.9C539.7,75.7,489,78.9,447,96.5c-17.6,7.4-34.6,17.2-53.5,19.7c-27.5,3.7-54.1-8.6-80.9-15.9
					c-36.4-10-76.3-10.6-110.7,5.3c-39,18.1-66.8,58.7-63.7,103.4c1.4,20.3,8.9,40.2,6.2,60.3c-2.7,20.4-14.4,37.5-20.7,56.8
					c-9.2,28.5-9.4,71.4,7.9,97.9h476.9C614.9,413.2,619.4,401.1,621.9,388.6z"/>
				<g>
					<path class="st2" d="M682.9,213.5c-2.9-30.2-16.9-60.4-41.2-82c-37.9-33.6-95.2-42-145.5-34.2c-21.1,3.3-42,9.1-63.5,7.3
						c-31.4-2.6-59.1-20.7-87.7-34c-39-18.1-83.6-27.8-125.1-19.8c-47,9-85.6,42.9-90.2,87.7c-2.1,20.3,19,56.1,12.3,75.3
						c-6.8,19.5-56.3,79.4-55.2,124.9c1.2,47.1,13.5,60.5,30.6,85.2h14.4h476.9h30.8c10.7-25.1,20.1-44.1,7.8-76.2
						c-9.3-24.5,16.2-44.7,26-67.5C682,260,685,235.6,682.9,213.5z"/>
				</g>
			</g>
		</g>
		<circle class="st4" cx="697.2" cy="271.4" r="4.6"/>
		<circle class="st4" cx="351.1" cy="37.6" r="4.6"/>
		<path class="st5" d="M668.1,399c0,2-1.6,3.6-3.6,3.6s-3.6-1.6-3.6-3.6c0-2,1.6-3.6,3.6-3.6S668.1,397,668.1,399z"/>
		<circle class="st5" cx="110.1" cy="112.1" r="4.6"/>
		<circle class="st4" cx="75.4" cy="284.6" r="3.6"/>
		<path class="st4" d="M82.1,134.6c0,0.8-0.7,1.5-1.5,1.5s-1.5-0.7-1.5-1.5c0-0.8,0.7-1.5,1.5-1.5S82.1,133.7,82.1,134.6z"/>
		<path class="st5" d="M474.6,48.5c-0.6,3-3.6,4.9-6.5,4.2c-3-0.6-4.9-3.6-4.2-6.5c0.6-3,3.6-4.9,6.5-4.2
			C473.3,42.6,475.2,45.6,474.6,48.5z"/>
		<path class="st5" d="M57,314c-0.6,3-3.6,4.9-6.5,4.2c-3-0.6-4.9-3.6-4.2-6.5c0.6-3,3.6-4.9,6.5-4.2C55.8,308.1,57.7,311,57,314z"/>
		<path class="st4" d="M426.5,82c-0.2,1-1.2,1.6-2.2,1.4c-1-0.2-1.6-1.2-1.4-2.2c0.2-1,1.2-1.6,2.2-1.4C426.1,80.1,426.7,81,426.5,82
			z"/>
	</g>
	<g id="OBJECTS">
		<g>
			<path class="st6" d="M224.5,352.8h-96.3c-2.5,0-4.5-2-4.5-4.5V243.4c0-2.5,2-4.5,4.5-4.5h96.3c2.5,0,4.5,2,4.5,4.5v104.9
				C229,350.8,227,352.8,224.5,352.8z"/>
			<path class="st0" d="M205.4,260.5h-59.1c-1.1,0-2-0.9-2-2v-8.2c0-1.1,0.9-2,2-2h59.1c1.1,0,2,0.9,2,2v8.2
				C207.4,259.6,206.5,260.5,205.4,260.5z"/>
			<path class="st0" d="M205.4,269.9h-59.1c-1.1,0-2-0.9-2-2v-0.1c0-1.1,0.9-2,2-2h59.1c1.1,0,2,0.9,2,2v0.1
				C207.4,269,206.5,269.9,205.4,269.9z"/>
			<path class="st0" d="M149.4,292.2c0,2.8-2.2,5-5,5c-2.8,0-5-2.2-5-5c0-2.8,2.2-5,5-5C147.2,287.2,149.4,289.4,149.4,292.2z"/>
			<path class="st0" d="M199.9,291h-48.7c-0.3,0-0.5-0.2-0.5-0.5s0.2-0.5,0.5-0.5h48.7c0.3,0,0.5,0.2,0.5,0.5S200.2,291,199.9,291z"
				/>
			<path class="st0" d="M175.6,296.2h-24.3c-0.3,0-0.5-0.2-0.5-0.5c0-0.3,0.2-0.5,0.5-0.5h24.3c0.3,0,0.5,0.2,0.5,0.5
				C176.1,296,175.9,296.2,175.6,296.2z"/>
			<path class="st0" d="M199.9,314.8h-48.7c-0.3,0-0.5-0.2-0.5-0.5c0-0.3,0.2-0.5,0.5-0.5h48.7c0.3,0,0.5,0.2,0.5,0.5
				C200.4,314.6,200.2,314.8,199.9,314.8z"/>
			<path class="st0" d="M175.6,320h-24.3c-0.3,0-0.5-0.2-0.5-0.5c0-0.3,0.2-0.5,0.5-0.5h24.3c0.3,0,0.5,0.2,0.5,0.5
				C176.1,319.8,175.9,320,175.6,320z"/>
		</g>
		<g>
			<rect x="342" y="365.6" class="st7" width="65.5" height="47.9"/>
			<path class="st7" d="M529,350.4H220.4c-4.6,0-8.3-3.7-8.3-8.3V159.4c0-4.6,3.7-8.3,8.3-8.3H529c4.6,0,8.3,3.7,8.3,8.3v182.7
				C537.3,346.7,533.6,350.4,529,350.4z"/>
			<path class="st8" d="M527.6,370.3H221.8c-5.3,0-9.7-5.1-9.7-11.4v-29.5h325.1v29.5C537.3,365.2,532.9,370.3,527.6,370.3z"/>
			<path class="st0" d="M521.5,328.6H228c-1,0-1.8-0.8-1.8-1.8V166.7c0-1,0.8-1.8,1.8-1.8h293.5c1,0,1.8,0.8,1.8,1.8v160.2
				C523.2,327.8,522.4,328.6,521.5,328.6z"/>
			<path class="st1" d="M500.9,317.7H248.5c-1,0-1.8-0.8-1.8-1.8V178.4c0-1,0.8-1.8,1.8-1.8h252.4c1,0,1.8,0.8,1.8,1.8v137.5
				C502.7,316.9,501.9,317.7,500.9,317.7z"/>
			<path class="st0" d="M374.7,362c-6.6,0-11.9-5.3-11.9-11.9s5.3-11.9,11.9-11.9c6.6,0,11.9,5.3,11.9,11.9S381.3,362,374.7,362z
				M374.7,339.2c-6,0-10.9,4.9-10.9,10.9c0,6,4.9,10.9,10.9,10.9c6,0,10.9-4.9,10.9-10.9C385.6,344.1,380.7,339.2,374.7,339.2z"/>
			<path class="st8" d="M444.3,421.7H305.1v-2c0-6.6,5.4-12,12-12h115.2c6.6,0,12,5.4,12,12V421.7z"/>
			<g>
				<circle class="st9" cx="374.7" cy="213.8" r="8.7"/>
				<circle class="st10" cx="374.7" cy="279.8" r="8.7"/>
				<circle class="st11" cx="407.7" cy="246.8" r="8.7"/>
				<circle class="st0" cx="341.7" cy="246.8" r="8.7"/>
				<path class="st12" d="M404.2,229.6c-3.4,3.4-8.9,3.4-12.3,0c-3.4-3.4-3.4-8.9,0-12.3c3.4-3.4,8.9-3.4,12.3,0
					C407.6,220.7,407.6,226.2,404.2,229.6z"/>
				<circle class="st13" cx="351.4" cy="270.1" r="8.7"/>
				<path class="st14" d="M391.9,276.3c-3.4-3.4-3.4-8.9,0-12.3c3.4-3.4,8.9-3.4,12.3,0c3.4,3.4,3.4,8.9,0,12.3
					C400.8,279.7,395.3,279.7,391.9,276.3z"/>
				<path class="st0" d="M345.2,229.6c-3.4-3.4-3.4-8.9,0-12.3c3.4-3.4,8.9-3.4,12.3,0c3.4,3.4,3.4,8.9,0,12.3
					C354.1,233,348.6,233,345.2,229.6z"/>
			</g>
			<g>
				<path class="st15" d="M521.5,181.7H228c-1,0-1.8-0.8-1.8-1.8v-13.2c0-1,0.8-1.8,1.8-1.8h293.5c1,0,1.8,0.8,1.8,1.8v13.2
					C523.2,180.9,522.4,181.7,521.5,181.7z"/>
				<path class="st3" d="M494.7,173c0,0.8-0.7,1.5-1.5,1.5c-0.8,0-1.5-0.7-1.5-1.5s0.7-1.5,1.5-1.5
					C494.1,171.5,494.7,172.2,494.7,173z"/>
				<path class="st3" d="M511,173c0,0.8-0.7,1.5-1.5,1.5s-1.5-0.7-1.5-1.5s0.7-1.5,1.5-1.5S511,172.2,511,173z"/>
				<circle class="st3" cx="501.4" cy="173" r="1.5"/>
			</g>
		</g>
		<g>
			<circle class="st16" cx="431.7" cy="263.1" r="69.7"/>
			
				<ellipse transform="matrix(0.9755 -0.22 0.22 0.9755 -38.0389 101.2496)" class="st1" cx="435.6" cy="221.4" rx="15.1" ry="15.1"/>
		</g>
		<path class="st4" d="M431.7,334.9c-39.6,0-71.7-32.2-71.7-71.7s32.2-71.7,71.7-71.7s71.7,32.2,71.7,71.7S471.2,334.9,431.7,334.9z
			M431.7,195.4c-37.3,0-67.7,30.4-67.7,67.7c0,37.3,30.4,67.7,67.7,67.7c37.3,0,67.7-30.4,67.7-67.7
			C499.4,225.8,469,195.4,431.7,195.4z"/>
		<g>
			<g>
				<path class="st7" d="M543.3,362.1l-45.9-45c-0.9-0.9-1.9-1.6-3-2c11.7-14.1,18.8-32.2,18.8-52c0-44.9-36.4-81.4-81.4-81.4
					s-81.4,36.4-81.4,81.4s36.4,81.4,81.4,81.4c18.8,0,36.1-6.4,49.9-17.1c0.5,1.3,1.2,2.5,2.3,3.5l45.9,45c1.9,1.8,4.3,2.8,6.7,2.8
					c2.5,0,5-1,6.9-2.9C547.1,372,547.1,365.8,543.3,362.1z M361.9,263.1c0-38.5,31.2-69.7,69.7-69.7s69.7,31.2,69.7,69.7
					s-31.2,69.7-69.7,69.7S361.9,301.7,361.9,263.1z"/>
			</g>
		</g>
		<g>
			<g>
				<path class="st17" d="M592.4,400.9l-66.8-66.8c-1.7-1.7-26.3,22.9-24.6,24.6l66.8,66.8c6.8,6.8,17.8,6.8,24.6,0v0
					C599.2,418.7,599.2,407.7,592.4,400.9z M587.3,412.2c0,3.4-2.7,6.1-6.1,6.1c-3.4,0-6.1-2.7-6.1-6.1v0c0-3.4,2.7-6.1,6.1-6.1
					C584.6,406.1,587.3,408.9,587.3,412.2L587.3,412.2z"/>
			</g>
			<g class="st18">
				<path class="st0" d="M584.6,417.3c-1,0.6-2.1,1-3.4,1c-3.4,0-6.1-2.7-6.1-6.1v0c0-1.3,0.4-2.5,1.1-3.5
					c-15.3-15.8-37.8-39-51.4-52.9c-7-7.2-11.6-12-11.7-11.9c-6.6,6.5-13.2,13.9-12.3,14.8l66.8,66.8c6.8,6.8,17.8,6.8,24.6,0v0
					C592.4,425.5,589.4,422.4,584.6,417.3z"/>
			</g>
			<path class="st0" d="M529.2,338.3l-24.1,24.1c-1.1,1.1-2.9,1.1-4,0l-4.4-4.4c-1.1-1.1-1.1-2.9,0-4l24.1-24.1c1.1-1.1,2.9-1.1,4,0
				l4.4,4.4C530.3,335.4,530.3,337.2,529.2,338.3z"/>
		</g>
		<path class="st19" d="M462,295.5L462,295.5c-2.7,2.7-7.1,2.7-9.8,0L398,241.4c-2.7-2.7-2.7-7.1,0-9.8v0c2.7-2.7,7.1-2.7,9.8,0
			l54.1,54.1C464.7,288.3,464.7,292.7,462,295.5z"/>
		<path class="st19" d="M398,295.5L398,295.5c2.7,2.7,7.1,2.7,9.8,0l54.1-54.1c2.7-2.7,2.7-7.1,0-9.8v0c-2.7-2.7-7.1-2.7-9.8,0
			L398,285.6C395.3,288.3,395.3,292.7,398,295.5z"/>
	</g>
	<g id="DESIGNED_BY_FREEPIK">
	</g>
	</svg>

	<header class="page-header">
		<h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'darkbiz' ); ?></h1>
	</header><!-- .page-header -->

	<?php if( current_user_can( 'publish_posts' ) ): ?>
		<div class="page-content">
			<?php get_search_form(); ?>
			<?php
				printf(
					'<p>%1$s</p><a href="%2$s">%3$s</a>',
					esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords or you can add post.', 'darkbiz' ),
					esc_url( admin_url( 'post-new.php' ) ),
					esc_html__( 'Get Started Here', 'darkbiz' )
				)
			?>
		</div><!-- .page-content -->
	<?php else: ?>
		<div class="page-content">
			<?php get_search_form();
				printf(
					'<p>%1$s</p> ',
					esc_html__( 'We can\'t seem to find any result that match your search key.', 'darkbiz' ),
					esc_url( admin_url( 'post-new.php' ) )
				)
			?>
		</div><!-- .page-content -->
		<div>
			<a href="<?php echo esc_url( home_url( '/' ) ) ?>" class="darkbiz-btn-primary"><?php echo esc_html__( 'Go To Homepage', 'darkbiz' ) ?> <i class="fa fa-long-arrow-right" aria-hidden="true"></i></a>
		</div>
	<?php endif; ?>
</section><!-- .no-results -->